from bpy.types import Operator
from ....libs.functions.get_common_vars import get_common_vars


class FLUIDLAB_OT_switcher_engine_cycles(Operator):
    bl_idname = "fluidlab.switcher_engine_cycles"
    bl_label = "Switcher to Cycles"
    bl_description = "Switch to Cycles"
    bl_options = {'REGISTER', 'UNDO'}

    def execute(self, context):

        scn = context.scene
        preferences = context.preferences.addons['cycles'].preferences
        
        # Seteamos Cycles:
        scn.render.engine = 'CYCLES'

        # Si el usuario tiene configurado algo no None, (CUDA, OPTIX o lo que sea):
        if preferences.compute_device_type != 'None':
            # Puedes obtener los nombres de los dispositivos disponibles usando preferences.devices
            # Asegúrate de que el dispositivo que seleccionas esté en la lista de dispositivos disponibles
            scn.cycles.device = 'GPU'
            scn.cycles.feature_set = 'SUPPORTED'
        
        return {'FINISHED'}


class FLUIDLAB_OT_switcher_engine_eevee(Operator):
    bl_idname = "fluidlab.switcher_engine_eevee"
    bl_label = "Switcher to Eevee"
    bl_description = "Switch to Eevee"
    bl_options = {'REGISTER', 'UNDO'}

    def execute(self, context):
        context.scene.render.engine = 'BLENDER_EEVEE'
        return {'FINISHED'}


class FLUIDLAB_OT_quick_mp4(Operator):
    bl_idname = "fluidlab.quick_mp4"
    bl_label = "Quick Mp4"
    bl_description = "Quick Setup to Mp4"
    bl_options = {'REGISTER', 'UNDO'}

    def execute(self, context):
        fluidlab = get_common_vars(context, get_fluidlab=True)
        fluidlab.rendering.file_format = 'FFMPEG'
        fluidlab.rendering.container = 'MPEG4'
        context.scene.render.image_settings.file_format = 'FFMPEG'
        context.scene.render.ffmpeg.format = 'MPEG4'
        context.scene.render.ffmpeg.constant_rate_factor = 'PERC_LOSSLESS'
        return {'FINISHED'}
